@extends('layouts.master')
@section('title') Inicio @endsection
@section('content')
<!-- this is breadcrumbs -->
@component('components.breadcrumb')
@slot('li_1') Inicio @endslot
@slot('li_2') Panel Estudiantes @endslot
@slot('title') Postulaciones @endslot
@endcomponent

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <div class="d-flex mb-3">
                    <div>
                        
                    </div>
                </div>

                <div class="table-responsive">
                    <table id="tablaPostulantes" class="table table-striped mb-0 table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>#</th>
                                <th>Empresa</th>
                                <th>Puesto</th>
                                <th>Fecha de Postulación</th>
                                <th>Estado Oferta</th>
                                <th>Acción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($postulaciones as $item)
                            <tr id="fila-{{ $item->id_postulacion }}">
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->oferta->empresa->nombre_empresa ?? 'N/A' }}</td>
                                <td>{{ $item->oferta->titulo }}</td>
                                <td>{{ \Carbon\Carbon::parse($item->fecha_postulacion)->format('d/m/Y') }}</td>
                                <td>
                                    @if(\Carbon\Carbon::parse($item->oferta->fecha_fin)->isPast())
                                        <span class="badge bg-danger">Vencida</span>
                                    @else
                                        <span class="badge bg-success">Activa</span>
                                    @endif
                                </td>
                                <td>
                                    @if(!\Carbon\Carbon::parse($item->oferta->fecha_fin)->isPast())
                                        <button class="btn btn-sm btn-danger btn-cancelar" data-id="{{ $item->id_postulacion }}">
                                            <i class="bi bi-x-circle"></i> Cancelar
                                        </button>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">No tienes postulaciones registradas.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
  

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>

<!-- Modal de agregar -->
<!-- Modal para crear nuevo requisito -->









<!--end row-->


@endsection
@section('script')
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaPostulantes").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaPostulantes_wrapper .col-md-6:eq(0)');
    });
</script>




<script>
$(document).on('click', '.btn-cancelar', function () {
    const id = $(this).data('id');

    Swal.fire({
        title: '¿Cancelar postulación?',
        text: 'Esta acción no se puede deshacer.',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'Sí, cancelar',
        cancelButtonText: 'No, mantener'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: '/postulaciones/' + id,
                type: 'POST',
                data: {
                    _method: 'DELETE',
                    _token: '{{ csrf_token() }}'
                },
                success: function (res) {
                    Swal.fire('Cancelado', res.success, 'success');
                    $('#fila-' + id).remove();
                },
                error: function (xhr) {
                    Swal.fire('Error', 'No se pudo cancelar la postulación.', 'error');
                }
            });
        }
    });
});
</script>





@endsection
