<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PracticaProfesional extends Model
{
    protected $table = 'practicas_profesionales';
    protected $primaryKey = 'id';
    public $timestamps = true;

    protected $fillable = [
        'postulante_id',
        'id_modulo',
        'id_asesor',
        'empresa_nombre',
        'empresa_ruc',
        'fecha_inicio',
        'fecha_fin',
        'fecha_registro',
        'nota',
        'observacion',
        'archivo_evidencia',
        'estado',
    ];

    // Relaciones

    public function postulante()
    {
        return $this->belongsTo(Postulante::class, 'postulante_id', 'id_postulante');
    }

    public function modulo()
    {
        return $this->belongsTo(ModuloFormativo::class, 'id_modulo', 'id_modulo');
    }

    public function asesor()
    {
        return $this->belongsTo(Docente::class, 'id_asesor', 'id');
    }
}
