<?php

namespace App\Http\Controllers;

use App\Models\Turno;
use Illuminate\Http\Request;

class TurnoController extends Controller
{
    // Mostrar lista de turnos
    public function index()
    {
        $turnos = Turno::all();
        return view('turnos.index', compact('turnos'));
    }

    // Registrar nuevo turno (AJAX)
    public function store(Request $request)
    {
        $request->validate([
            'nombre' => 'required|string|max:100',
            
            'hora_inicio' => 'required|date_format:H:i',  // Validación de hora
            'hora_fin' => 'required|date_format:H:i',      // Validación de hora
        ]);

        $turno = Turno::create([
            'nombre' => $request->nombre,
            
            'hora_inicio' => $request->hora_inicio,
            'hora_fin' => $request->hora_fin,
        ]);

        return response()->json([
            'success' => true,
            'message' => 'Turno registrado correctamente.',
            'turno' => $turno
        ]);
    }


    // Obtener datos de un turno específico para edición
    public function show($id)
    {
        $turno = Turno::findOrFail($id);
        return response()->json($turno);
    }

    public function edit($id)
    {
        $turno = Turno::findOrFail($id);
        return view('turnos.edit', compact('turno'));
    }


    // Actualizar un turno (AJAX)
    public function update(Request $request, $id)
    {
        // Validación de los campos recibidos
        $request->validate([
            'nombre' => 'required|string|max:100',
            
        ]);

        // Buscar el turno en la base de datos
        $turno = Turno::findOrFail($id);

        // Actualizar el turno con los nuevos datos
        $turno->update([
            'nombre' => $request->nombre,
            'hora_inicio' => $request->hora_inicio,
            'hora_fin' => $request->hora_fin,
        ]);

        // Responder con un mensaje de éxito
        return response()->json([
            'success' => true,
            'message' => 'Turno actualizado correctamente.'
        ]);
    }


    // Eliminar un turno (AJAX)
    public function destroy($id)
    {
        $turno = Turno::findOrFail($id);
        $turno->delete();

        return response()->json([
            'success' => true,
            'message' => 'Turno eliminado correctamente.'
        ]);
    }

}
